/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCHLOCChartFormat;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class HLOCChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    static final int HILO_PT_INDEX = 0;
    static final int OPEN_PT_INDEX = 1;
    static final int CLOSE_PT_INDEX = 2;
    static final int HLOC_PT_ARRAY = 3;
    static final int NUM_PER_PT = 2;
    static final int OPEN_SERIES_INDEX = 2;
    JCHLOCChartFormat hlocf;
    PlotPoint[][][] pts;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        this.cachePlotData = this.dataObject.getBufferPlotData();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.hlocf = this.dataObject.getHLOCChartFormat();
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.holeValue = this.dataObject.holeValue;
        this.inverted = this.xaxis.isVertical;
        int n2 = this.seriesList.length / 4;
        if (!this.cachePlotData && n == -1) {
            if (this.pts == null) {
                this.pts = new PlotPoint[n2][][];
            }
            return;
        }
        if (n == -1 || n == 0) {
            this.xlim = new MinMax();
            this.ylim = new MinMax();
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
        this.pts = new PlotPoint[n2][][];
        boolean bl = this.hlocf.getIsOpenCloseFullWidth();
        boolean bl2 = this.hlocf.getIsShowingOpen();
        boolean bl3 = this.hlocf.getIsShowingClose();
        int n3 = n == -1 ? 0 : n;
        int n4 = n == -1 ? n2 : n + 1;
        int n5 = n3;
        while (n5 < n4) {
            this.pts[n5] = null;
            int n6 = this.hlocf.getTickSize(n5);
            boolean bl4 = true;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            int n9 = Integer.MAX_VALUE;
            int n10 = 4 * n5;
            int n11 = 0;
            while (n11 < 4) {
                ChartDataViewSeries chartDataViewSeries = this.seriesList[n10];
                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                    bl4 = false;
                    break;
                }
                n7 = Math.min(n7, chartDataViewSeries.maxXIndex());
                n7 = Math.min(n7, chartDataViewSeries.maxYIndex());
                n8 = Math.min(n8, chartDataViewSeries.getFirstPoint());
                n9 = Math.min(n9, chartDataViewSeries.getLastPoint());
                ++n11;
                ++n10;
            }
            if (bl4) {
                this.pts[n5] = new PlotPoint[n7][];
                int n12 = n8;
                while (n12 <= n9) {
                    int n13;
                    double d;
                    double d2;
                    int n14 = 0;
                    this.pts[n5][n12] = new PlotPoint[6];
                    int n15 = 4 * n5;
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n15++];
                    double d3 = chartDataViewSeries.getX(n12);
                    double d4 = chartDataViewSeries.getY(n12);
                    chartDataViewSeries = this.seriesList[n15++];
                    double d5 = chartDataViewSeries.getX(n12);
                    double d6 = chartDataViewSeries.getY(n12);
                    this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, this.pts[n5][n12], n12, n14, this.inverted, false);
                    if (n6 > 0 && bl2) {
                        n14 = 2;
                        chartDataViewSeries = this.seriesList[n15++];
                        d2 = chartDataViewSeries.getX(n12);
                        d = chartDataViewSeries.getY(n12);
                        n13 = this.xaxis.toPixel(d2, this.drawFront);
                        d3 = this.xaxis.toData(n13 - n6, this.drawFront);
                        d4 = d;
                        d5 = bl ? this.xaxis.toData(n13 + n6, this.drawFront) : d2;
                        d6 = d;
                        this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, this.pts[n5][n12], n12, n14, this.inverted, false);
                    }
                    if (n6 > 0 && bl3) {
                        n14 = 4;
                        chartDataViewSeries = this.seriesList[n15++];
                        d2 = chartDataViewSeries.getX(n12);
                        d = chartDataViewSeries.getY(n12);
                        n13 = this.xaxis.toPixel(d2, this.drawFront);
                        d3 = bl ? this.xaxis.toData(n13 - n6, this.drawFront) : d2;
                        d4 = d;
                        d5 = this.xaxis.toData(n13 + n6, this.drawFront);
                        d6 = d;
                        this.financialClip(d3, d4, d5, d6, this.xlim, this.ylim, this.pts[n5][n12], n12, n14, this.inverted, false);
                    }
                    ++n12;
                }
            }
            ++n5;
        }
    }

    public void draw(Graphics graphics) {
        if (this.pts == null) {
            return;
        }
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        boolean bl = false;
        PlotPoint plotPoint = null;
        try {
            if (this.seriesList == null) {
                return;
            }
            boolean bl2 = this.hlocf.getIsShowingOpen();
            boolean bl3 = this.hlocf.getIsShowingClose();
            int n = 0;
            while (n < this.pts.length) {
                if (!this.cachePlotData) {
                    this.recalc(n);
                }
                if (this.pts[n] != null) {
                    JCChartStyle jCChartStyle;
                    boolean bl4 = true;
                    int n2 = 4 * n;
                    int n3 = 0;
                    while (n3 < 4) {
                        if (!this.seriesList[n2].isShowing) {
                            bl4 = false;
                            break;
                        }
                        ++n3;
                        ++n2;
                    }
                    if (bl4 && (jCChartStyle = this.seriesList[4 * n].getStyle()) != null) {
                        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                        int n4 = 0;
                        while (n4 < this.pts[n].length) {
                            if (this.pts[n][n4] != null) {
                                int n5 = 0;
                                while (n5 < this.pts[n][n4].length / 2) {
                                    if (this.pts[n][n4][n5 * 2] != null && (n5 != 1 || bl2) && (n5 != 2 || bl3)) {
                                        bl = false;
                                        int n6 = 0;
                                        while (n6 < 2) {
                                            int n7 = n5 * 2 + n6;
                                            plotPoint = this.pts[n][n4][n7];
                                            if (plotPoint == null || plotPoint.px == Integer.MAX_VALUE || plotPoint.py == Integer.MAX_VALUE) {
                                                bl = false;
                                            } else {
                                                point.x = plotPoint.px;
                                                point.y = plotPoint.py;
                                                if (bl) {
                                                    jCLineStyle.draw(graphics, point2.x, point2.y, point.x, point.y);
                                                }
                                                point2.x = point.x;
                                                point2.y = point.y;
                                                bl = true;
                                            }
                                            ++n6;
                                        }
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                        if (!this.cachePlotData) {
                            this.pts[n] = null;
                        }
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        PlotPoint plotPoint = null;
        boolean bl = this.hlocf.getIsShowingOpen();
        boolean bl2 = this.hlocf.getIsShowingClose();
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (!this.cachePlotData) {
                this.recalc(n5);
            }
            if (this.pts[n5] != null) {
                boolean bl3 = true;
                int n6 = 4 * n5;
                int n7 = 0;
                while (n7 < 4) {
                    if (!this.seriesList[n6].isShowing) {
                        bl3 = false;
                        break;
                    }
                    ++n7;
                    ++n6;
                }
                if (bl3) {
                    int n8 = 0;
                    while (n8 < this.pts[n5].length) {
                        if (this.pts[n5][n8] != null) {
                            int n9 = 0;
                            while (n9 < this.pts[n5][n8].length / 2) {
                                if (this.pts[n5][n8][n9 * 2] != null && (n9 != 1 || bl) && (n9 != 2 || bl2)) {
                                    int n10 = 0;
                                    while (n10 < 2) {
                                        int n11 = n9 * 2 + n10;
                                        plotPoint = this.pts[n5][n8][n11];
                                        if (plotPoint != null && plotPoint.px != Integer.MAX_VALUE && plotPoint.py != Integer.MAX_VALUE && plotPoint.drawPoint) {
                                            int n12 = Integer.MAX_VALUE;
                                            switch (n) {
                                                case 1: {
                                                    n12 = Math.abs(plotPoint.px - point2.x);
                                                    break;
                                                }
                                                case 2: {
                                                    n12 = Math.abs(plotPoint.py - point2.y);
                                                    break;
                                                }
                                                default: {
                                                    n12 = JCChartUtil.distance(point2.x, point2.y, plotPoint.px, plotPoint.py);
                                                }
                                            }
                                            if (n12 < n4) {
                                                int n13 = n9 == 0 ? n10 : n9 + 1;
                                                n2 = n5 * 4 + n13;
                                                n3 = plotPoint.point;
                                                n4 = n12;
                                            }
                                        }
                                        ++n10;
                                    }
                                }
                                ++n9;
                            }
                        }
                        ++n8;
                    }
                    if (!this.cachePlotData) {
                        this.pts[n5] = null;
                    }
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        int n;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n2 = jCDataIndex.series.drawingOrder / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n3 = jCDataIndex.point;
        int n4 = n = jCDataIndex.seriesIndex - n2 * 4;
        int n5 = 0;
        if (n < 2) {
            boolean bl = false;
        } else {
            int n6 = n - 1;
            n5 = n6 * 2;
            n4 = n5 + (n == 2 ? 1 : 0);
        }
        PlotPoint[] plotPointArray = this.pts[n2][n3];
        if (n4 >= n5 && n4 < n5 + 2 && plotPointArray[n4] != null && plotPointArray[n4].px != Integer.MAX_VALUE && plotPointArray[n4].py != Integer.MAX_VALUE) {
            if (n >= 2 && this.hlocf.getIsOpenCloseFullWidth()) {
                if (this.xaxis.isVertical) {
                    this.start = new Point(plotPointArray[n4].px + this.r.x, (plotPointArray[n5].py + plotPointArray[n5 + 1].py) / 2 + this.r.y);
                    return;
                }
                this.start = new Point((plotPointArray[n5].px + plotPointArray[n5 + 1].px) / 2 + this.r.x, plotPointArray[n4].py + this.r.y);
                return;
            }
            this.start = new Point(plotPointArray[n4].px + this.r.x, plotPointArray[n4].py + this.r.y);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 4;
    }
}

